% Road_creation_1D
% Vytvari zvlneni vozovky
%-------------------------------------------------------------------------
% Witten By Tomas Mauder, VUT v Brne, 2014.
%-------------------------------------------------------------------------
function y = Road_creation_1D(road,A, omega, psi,graphs)

% Delka cesty (m)
L1 = road.L1;
L2 = road.L2;
L = L2 - L1;

% Pocet vzorku na 1 m cesty
N = road.N;
% Rozdeleni cesty na L * N intervalu
s = road.s;

% Inicializace zvlneni vozovky
y = zeros(1,N * L);

% Vypocet zvlneni vozovky (eq. 2.17)
for i = 1 : N * L + 1
                y(i)=sum((A.* sin((omega* s(i)) - psi')));
        
% progress bar     
     drawnow                
     stopBar = progressbar(i/(N * L),4);
     if (stopBar); break; end
        
end

% Nastaveni pocatecni podminky na 0
%   y(1:N * L) = y(1:N * L) - y(1);
close
%-------------------------------------------------------------------------
if graphs == 1
figure
% x - vzdalenost [m], y - zvlneni [cm]

plot(s,y*100);
title('Profil cesty');
xlabel('Vzdalenost [m]');
ylabel('Zvlneni povrchu vozovky [cm]');
set(gcf,'Color','w');

end